//Note: Details of scilab software version and OS version used:
//Tested on OS: Windows 7 SP1, 64 bit and Windows XP SP3, 32 bit
//Scilab version: 5.4.1 (Tested on both 32 bit and 64 bit versions)
//Program Title: Study and generate 8-QAM waveforms

clear;
clc;
close;
T=3; //One Symbol period
t = 0:0.01:T; // Sampling Matrix for one symbol period
f=1/T; // Carrier frequency (cycles per bit period)
I=[0 0 0 0 0 1 0 1 0 0 1 1 1 0 0 1 0 1 1 1 0 1 1 1]; //data stream giving tribits equivalent to 0,1,2,3,4,5,6,7

//Polar NRZ Converter
I_PNRZ = [] //empty matrix for Polar NRZ data
       for n = 1:length(I)
           if I(n)== 0 then
               I_PNRZ = [I_PNRZ, -1]
           else
               I_PNRZ = [I_PNRZ, 1]
           end
       end

I_Carrier = sqrt(2/T)*cos(2*%pi*f*t); // In phase carrier
Q_Carrier = sqrt(2/T)*sin(2*%pi*f*t); // Quadrature phase carrier

//Generation of 8-QAM Waveform

z=0;//Starting point of plot on x-axis 
for n=1:3:length(I_PNRZ)
    Q_Bit=I_PNRZ(n)//Set Q Bit Value
    I_Bit=I_PNRZ(n+1)//Set I Bit Value
    C_Bit=I_PNRZ(n+2)//Set C Bit Value
        if C_Bit==-1 then //Set PAM, Product of C with I or Q 
            QC=0.5*Q_Bit//Set half amplitude
            IC=0.5*I_Bit//Set half amplitude
        else
            QC=Q_Bit//Set full amplitude
            IC=I_Bit//Set full amplitude
        end

    subplot(3,1,1) //QC Plot
        a=gca();
        a.data_bounds=[0,-1.5;length(I_PNRZ),1.5]; 
        a.x_location="origin";
        a.grid=[1,1];
        title('Q-PAM')
            plot((t+z),Q_Carrier*QC);//Q_Carrier * Q-PAM (Q Balance Modulator)
            plot((t+z),QC,'r');//Q-PAM Output
            
    subplot(3,1,2) //IC Plot
        a=gca();
        a.data_bounds=[0,-1.5;length(I_PNRZ),1.5];
        a.x_location="origin";
        a.grid=[1,1];
        title('I-PAM')
            plot((t+z),I_Carrier*IC);//I_Carrier * I-PAM (I Balance Modulator)
            plot((t+z),IC,'r');//I-PAM Output

    subplot(3,1,3) //8-QAM Plot
        a=gca();
        a.data_bounds=[0,-1.5;length(I_PNRZ),1.5]; 
        a.x_location="origin";
        a.grid=[1,1];
        title('8-QAM')
            plot((t+z),(I_Carrier*IC)+(Q_Carrier*QC));//I-PAM + Q-PAM (Adder)
            plot((t+z),I_Carrier,'r');//I Carrier for reference
            plot(((t/3)+z),Q_Bit,'c');//Q Bit for reference
            plot(((t/3)+1+z),I_Bit,'b');//I Bit for reference
            plot(((t/3)+2+z),C_Bit,'m');//C Bit for reference
            
z=z+3;//Move starting point of plot on x-axis by 3 bits (1 symbol) period
end
